/**
 * Ads Insight Pro - Onboarding Flow
 */

let currentStep = 1;
const totalSteps = 4;

document.addEventListener('DOMContentLoaded', init);

function init() {
  setupEventListeners();
  showStep(1);
}

function setupEventListeners() {
  // Next buttons
  document.querySelectorAll('.btn-next').forEach(btn => {
    btn.addEventListener('click', () => {
      const nextStep = parseInt(btn.dataset.next);
      if (nextStep && nextStep <= totalSteps) {
        showStep(nextStep);
      }
    });
  });
  
  // Back buttons
  document.querySelectorAll('.btn-back').forEach(btn => {
    btn.addEventListener('click', () => {
      const backStep = parseInt(btn.dataset.back);
      if (backStep && backStep >= 1) {
        showStep(backStep);
      }
    });
  });
  
  // Skip account
  const skipBtn = document.getElementById('btn-skip-account');
  if (skipBtn) {
    skipBtn.addEventListener('click', () => {
      showStep(4);
    });
  }
  
  // Create account
  const createBtn = document.getElementById('btn-create-account');
  if (createBtn) {
    createBtn.addEventListener('click', () => {
      // Open account page in new tab
      chrome.tabs.create({ url: 'https://adsinsightpro.com/signup' });
      showStep(4);
    });
  }
  
  // Open transparency page
  const openBtn = document.getElementById('btn-open-transparency');
  if (openBtn) {
    openBtn.addEventListener('click', () => {
      chrome.tabs.create({ url: 'https://adstransparency.google.com/' });
      completeOnboarding();
    });
  }
  
  // Close onboarding
  const closeBtn = document.getElementById('btn-close-onboarding');
  if (closeBtn) {
    closeBtn.addEventListener('click', () => {
      completeOnboarding();
    });
  }
  
  // Progress dots click
  document.querySelectorAll('.dot').forEach(dot => {
    dot.addEventListener('click', () => {
      const step = parseInt(dot.dataset.step);
      if (step && step <= currentStep) {
        showStep(step);
      }
    });
  });
}

function showStep(step) {
  currentStep = step;
  
  // Hide all steps
  document.querySelectorAll('.onboarding-step').forEach(el => {
    el.classList.remove('active');
  });
  
  // Show current step
  document.querySelector(`.onboarding-step[data-step="${step}"]`).classList.add('active');
  
  // Update progress dots
  document.querySelectorAll('.dot').forEach(dot => {
    const dotStep = parseInt(dot.dataset.step);
    dot.classList.toggle('active', dotStep === step);
  });
}

async function completeOnboarding() {
  // Mark onboarding as complete
  await chrome.storage.local.set({ 
    onboardingComplete: true,
    onboardingCompletedAt: Date.now()
  });
  
  // Close popup or redirect to main
  window.location.href = 'popup.html';
}
